#ifndef VECTOR_HPP
#define VECTOR_HPP

#include "types.h"
#include "frame2.hpp" //for GetCursorPos
//--TWO DIMENSIONAL STUFF------

class Vector2
{
private:
	Real _x,_y;
public:
	//--------Constructors------------------------------
	Vector2(){_x = _y = 0.0;}
	Vector2(Real ix, Real iy){_x = ix; _y = iy;}
	//--------Accessors------------------------------
	Real x()const {return _x;}
	Real y()const {return _y;}
	Real Magnitude()const; //Return the Vector2's length.
	//--------Mutators------------------------------
	void Set(Real ix, Real iy){_x = ix; _y = iy;}
	Vector2 Normalize(); //Make yourself of unit length and return self.
	Real MagnitudeNormalize(); //Make yourself of unit length, return magnitude.
	Vector2 Rotate(Real angle); //Rotate angle radians
	//--------Operators------------------------------
	Vector2 operator=(const Vector2 &u){_x=u._x; _y=u._y; return *this;}
	Vector2 operator+=(const Vector2 &u){_x+=u._x; _y+=u._y; return *this;}
	Vector2 operator-=(const Vector2 &u){_x-=u._x; _y-=u._y; return *this;}
	Vector2 operator*=(Real f){_x*=f; _y*=f; return *this;}
	Vector2 operator/=(Real f);
	BOOL operator()(void){return !(*this == Vector2(0.0, 0.0));} //v() TRUE means not zero
	friend Vector2 operator*(const Vector2 &u, Real f); //Scalar prod
	friend Vector2 operator*(Real f, const Vector2 &u); //Scalar prod
	friend Vector2 operator+(const Vector2 &u, const Vector2 &v); //Vector2 sum
	friend Vector2 operator-(const Vector2 &u, const Vector2 &v); //Vector2 difference
	friend Real operator%(const Vector2 &u, const Vector2 &v); //Dot product
	friend int operator==(const Vector2 &u, const Vector2 &v) //equality predicate.
		{if (u._x == v._x && u._y == v._y) return 1; else return 0;}
};


#endif //VECTOR_HPP
